//-------------------------------------------
// Meta Boxes manipulations
//-------------------------------------------
jQuery(document).ready(function() {
	"use strict";

	// jQuery Tabs
	jQuery('#mckinney_politics_meta_box_tabs').tabs();

	// Toggle inherit button and cover
	jQuery('#mckinney_politics_meta_box_tabs').on('click', '.mckinney_politics_meta_box_inherit_lock,.mckinney_politics_meta_box_inherit_cover', function (e) {
		"use strict";
		var parent = jQuery(this).parents('.mckinney_politics_meta_box_item');
		var inherit = parent.hasClass('mckinney_politics_meta_box_inherit_on');
		if (inherit) {
			parent.removeClass('mckinney_politics_meta_box_inherit_on').addClass('mckinney_politics_meta_box_inherit_off');
			parent.find('.mckinney_politics_meta_box_inherit_cover').fadeOut().find('input[type="hidden"]').val('');
		} else {
			parent.removeClass('mckinney_politics_meta_box_inherit_off').addClass('mckinney_politics_meta_box_inherit_on');
			parent.find('.mckinney_politics_meta_box_inherit_cover').fadeIn().find('input[type="hidden"]').val('inherit');
			
		}
		e.preventDefault();
		return false;
	});
	
	// Check dependencies
	jQuery('.mckinney_politics_meta_box .mckinney_politics_meta_box_section').each(function () {
		"use strict";
		mckinney_politics_meta_box_check_dependencies(jQuery(this));
	});
	jQuery('.mckinney_politics_meta_box .mckinney_politics_meta_box_item_field [name^="mckinney_politics_meta_box_field_"]').on('change', function () {
		"use strict";
		mckinney_politics_meta_box_check_dependencies(jQuery(this).parents('.mckinney_politics_meta_box_section'));
	});

});


// Check for dependencies
function mckinney_politics_meta_box_check_dependencies(cont) {
	"use strict";
	cont.find('.mckinney_politics_meta_box_item_field').each(function() {
		"use strict";
		var id = jQuery(this).data('param');
		if (id == undefined) return;
		var depend = false;
		for (var fld in mckinney_politics_dependencies) {
			if (fld == id) {
				depend = mckinney_politics_dependencies[id];
				break;
			}
		}
		if (depend) {
			var dep_cnt = 0, dep_all = 0;
			var dep_cmp = typeof depend.compare != 'undefined' ? depend.compare.toLowerCase() : 'and';
			var dep_strict = typeof depend.strict != 'undefined';
			var fld=null, val='', name='', subname='';
			var parts = '', parts2 = '';
			for (var i in depend) {
				if (i == 'compare' || i == 'strict') continue;
				dep_all++;
				name = i;
				subname = '';
				if (name.indexOf('[') > 0) {
					parts = name.split('[');
					name = parts[0];
					subname = parts[1].replace(']', '');
				}
				if (name.charAt(0)=='#' || name.charAt(0)=='.') {
					fld = jQuery(name);
					if (fld.length > 0 && !fld.hasClass('trx_addons_inited')) {
						fld.addClass('trx_addons_inited').on('change', function () {
							jQuery('.mckinney_politics_meta_box .mckinney_politics_meta_box_section').each(function () {
								mckinney_politics_meta_box_check_dependencies(jQuery(this));
							});
						});
					}
				} else
					fld = cont.find('[name="mckinney_politics_meta_box_field_'+name+'"]');
				if (fld.length > 0) {
					val = fld.attr('type')=='checkbox' || fld.attr('type')=='radio' 
								? (fld.parents('.mckinney_politics_meta_box_item_field').find('[name^="mckinney_politics_meta_box_field_"]:checked').length > 0 
									? fld.parents('.mckinney_politics_meta_box_item_field').find('[name^="mckinney_politics_meta_box_field_"]:checked').val()
									: 0
									)
								: fld.val();
					if (val===undefined) val = '';
					if (subname!='') {
						parts = val.split('|');
						for (var p=0; p<parts.length; p++) {
							parts2 = parts[p].split('=');
							if (parts2[0]==subname) {
								val = parts2[1];
							}
						}
					}
					for (var j in depend[i]) {
						if ( 
							   (depend[i][j]=='not_empty' && val!='') 										// Main field value is not empty - show current field
							|| (depend[i][j]=='is_empty' && val=='')										// Main field value is empty - show current field
							|| (val!=='' && (!isNaN(depend[i][j]) 											// Main field value equal to specified value - show current field
												? val==depend[i][j]
												: (dep_strict 
														? val==depend[i][j]
														: val.indexOf(depend[i][j])==0
													)
											)
								)
							|| (val!=='' && (""+depend[i][j]).charAt(0)=='^' && val.indexOf(depend[i][j].substr(1))==-1)	// Main field value not equal to specified value - show current field
						) {
							dep_cnt++;
							break;
						}
					}
				} else
					dep_all--;
				if (dep_cnt > 0 && dep_cmp == 'or')
					break;
			}
			if ((dep_cnt > 0 && dep_cmp == 'or') || (dep_cnt == dep_all && dep_cmp == 'and')) {
				jQuery(this).parents('.mckinney_politics_meta_box_item').show().removeClass('mckinney_politics_meta_box_no_use');
			} else {
				jQuery(this).parents('.mckinney_politics_meta_box_item').hide().addClass('mckinney_politics_meta_box_no_use');
			}
		}
	});
}
