<?php
/* Content Timeline support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_content_timeline_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_content_timeline_theme_setup9', 9 );
	function mckinney_politics_content_timeline_theme_setup9() {
		
		// One-click importer support
		if (mckinney_politics_exists_content_timeline()) {
			add_action( 'wp_enqueue_scripts', 										'mckinney_politics_content_timeline_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_content_timeline_merge_styles' );
			add_filter( 'mckinney_politics_filter_get_css',							'mckinney_politics_content_timeline_get_css', 10, 3 );
			if (is_admin()) {
				add_filter( 'mckinney_politics_filter_importer_options',				'mckinney_politics_content_timeline_importer_set_options' );
				add_action( 'mckinney_politics_action_importer_params',				'mckinney_politics_content_timeline_importer_show_params', 10, 1 );
				add_action( 'mckinney_politics_action_importer_import',				'mckinney_politics_content_timeline_importer_import', 10, 2 );
				add_action( 'mckinney_politics_action_importer_import_fields',		'mckinney_politics_content_timeline_importer_import_fields', 10, 1 );
				add_action( 'mckinney_politics_action_importer_export',				'mckinney_politics_content_timeline_importer_export', 10, 1 );
				add_action( 'mckinney_politics_action_importer_export_fields',		'mckinney_politics_content_timeline_importer_export_fields', 10, 1 );
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_importer_required_plugins',			'mckinney_politics_content_timeline_importer_required_plugins', 10, 2 );
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_content_timeline_tgmpa_required_plugins' );
		}

	}
}

// Check if plugin is installed and activated
if ( !function_exists( 'mckinney_politics_exists_content_timeline' ) ) {
	function mckinney_politics_exists_content_timeline() {
		return class_exists( 'ContentTimelineAdmin' );
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'mckinney_politics_content_timeline_frontend_scripts' ) ) {
	//add_action( 'wp_enqueue_scripts', 'mckinney_politics_content_timeline_frontend_scripts', 1100 );
	function mckinney_politics_content_timeline_frontend_scripts() {
		if ( mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.content_timeline.css')))
			mckinney_politics_enqueue_style( 'mckinney_politics-plugin.content_timeline',  mckinney_politics_get_file_url('css/plugin.content_timeline.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_content_timeline_merge_styles' ) ) {
	//add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_content_timeline_merge_styles');
	function mckinney_politics_content_timeline_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.content_timeline.css'));
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_content_timeline_tgmpa_required_plugins' ) ) {
	//add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_content_timeline_tgmpa_required_plugins');
	function mckinney_politics_content_timeline_tgmpa_required_plugins($list=array()) {
		if (in_array('content_timeline', mckinney_politics_storage_get('required_plugins'))) {
			$path = mckinney_politics_get_file_dir('plugins/install/content_timeline.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('Content Timeline', 'mckinney-politics'),
						'slug' 		=> 'content_timeline',
						'source'	=> $path,
						'required' 	=> false
					);
			}
		}
		return $list;
	}
}



// One-click import support
//------------------------------------------------------------------------

// Check plugin in the required plugins
if ( !function_exists( 'mckinney_politics_content_timeline_importer_required_plugins' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_required_plugins',	'mckinney_politics_content_timeline_importer_required_plugins', 10, 2 );
	function mckinney_politics_content_timeline_importer_required_plugins($not_installed='', $list='') {
		//if (in_array('content_timeline', mckinney_politics_storage_get('required_plugins')) && !mckinney_politics_exists_content_timeline() )
		if (strpos($list, 'content_timeline')!==false && !mckinney_politics_exists_content_timeline() )
			$not_installed .= '<br>' . esc_html__('Content Timeline', 'mckinney-politics');
		return $not_installed;
	}
}

// Set options for one-click importer
if ( !function_exists( 'mckinney_politics_content_timeline_importer_set_options' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_options',	'mckinney_politics_content_timeline_importer_set_options' );
	function mckinney_politics_content_timeline_importer_set_options($options=array()) {
		if ( in_array('content_timeline', mckinney_politics_storage_get('required_plugins')) && mckinney_politics_exists_content_timeline() ) {
			//$options['additional_options'][] = 'content_timeline_calendar_options';
			if (is_array($options['files']) && count($options['files']) > 0) {
				foreach ($options['files'] as $k => $v) {
					$options['files'][$k]['file_with_content_timeline'] = str_replace('posts', 'content_timeline', $v['file_with_posts']);
				}
			}
		}
		return $options;
	}
}

// Add checkbox to the one-click importer
if ( !function_exists( 'mckinney_politics_content_timeline_importer_show_params' ) ) {
	//add_action( 'mckinney_politics_action_importer_params',	'mckinney_politics_content_timeline_importer_show_params', 10, 1 );
	function mckinney_politics_content_timeline_importer_show_params($importer) {
		?>
		<input type="checkbox" <?php echo in_array('content_timeline', mckinney_politics_storage_get('required_plugins')) && $importer->options['plugins_initial_state'] 
											? 'checked="checked"' 
											: ''; ?> value="1" name="import_content_timeline" id="import_content_timeline" /> <label for="import_content_timeline"><?php esc_html_e('Import Content Timeline', 'mckinney-politics'); ?></label><br>
		<?php
	}
}

// Import posts
if ( !function_exists( 'mckinney_politics_content_timeline_importer_import' ) ) {
	//add_action( 'mckinney_politics_action_importer_import',	'mckinney_politics_content_timeline_importer_import', 10, 2 );
	function mckinney_politics_content_timeline_importer_import($importer, $action) {
		if ( $action == 'import_content_timeline' ) {
			$importer->response['result'] = $importer->import_dump('content_timeline', esc_html__('Content Timeline', 'mckinney-politics'));
		}
	}
}

// Display import progress
if ( !function_exists( 'mckinney_politics_content_timeline_importer_import_fields' ) ) {
	//add_action( 'mckinney_politics_action_importer_import_fields',	'mckinney_politics_content_timeline_importer_import_fields', 10, 1 );
	function mckinney_politics_content_timeline_importer_import_fields($importer) {
		?>
		<tr class="import_content_timeline">
			<td class="import_progress_item"><?php esc_html_e('Content Timeline', 'mckinney-politics'); ?></td>
			<td class="import_progress_status"></td>
		</tr>
		<?php
	}
}

// Export posts
if ( !function_exists( 'mckinney_politics_content_timeline_importer_export' ) ) {
	//add_action( 'mckinney_politics_action_importer_export',	'mckinney_politics_content_timeline_importer_export', 10, 1 );
	function mckinney_politics_content_timeline_importer_export($importer) {
		mckinney_politics_storage_set('export_content_timeline', serialize( array(
			'ctimelines' => $importer->export_dump('ctimelines')
			) )
		);
	}
}

// Display exported data in the fields
if ( !function_exists( 'mckinney_politics_content_timeline_importer_export_fields' ) ) {
	//add_action( 'mckinney_politics_action_importer_export_fields',	'mckinney_politics_content_timeline_importer_export_fields', 10, 1 );
	function mckinney_politics_content_timeline_importer_export_fields($importer) {
		?>
		<tr>
			<th align="left"><?php esc_html_e('Content Timeline', 'mckinney-politics'); ?></th>
			<td><?php mckinney_politics_fpc(mckinney_politics_get_file_dir('importer/export/content_timeline.txt'), mckinney_politics_storage_get('export_content_timeline')); ?>
				<a download="content_timeline.txt" href="<?php echo esc_url(mckinney_politics_get_file_url('importer/export/content_timeline.txt')); ?>"><?php esc_html_e('Download', 'mckinney-politics'); ?></a>
			</td>
		</tr>
		<?php
	}
}


// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_content_timeline_get_css' ) ) {
	//add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_content_timeline_get_css', 10, 3 );
	function mckinney_politics_content_timeline_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS
#tl2.my_style_style_2 .my_icon,
#tl2.my_style_style_2 .my_share_items span,
#tl2.my_style_style_2 .my_post_date.
#tl2.my_style_style_2 .item .my_category,
.timeline h4.t_line_month, #content .timeline h4.t_line_month,
.timeline.my_style_style_1 .t_line_month,
.timeline.my_style_style_1 a.t_line_node,
.timeline.my_style_style_1 .item .my_timeline_content .read_more {
	font-family: {$fonts['p']['family']} !important;
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

/* Timeline */
.timeline h4.t_line_month,
#content .timeline h4.t_line_month {
	color: {$colors['text_link']}
}
.timeline.flatLine #t_line_left, .timeline.flatLine #t_line_right, #content .timeline.flatLine #t_line_left, #content .timeline.flatLine #t_line_right {
	color: {$colors['text_link']}
}
.my_style_style_2 .ti-heart {
	color: {$colors['text_link']}
}
#tl1.timeline.my_style_style_1 .t_line_node {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 .t_line_node.active {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 .t_line_node:after {
	background: {$colors['inverse_text']} !important;
}
#tl1.timeline.my_style_style_1 .t_line_node:hover:after,
#tl1.timeline.my_style_style_1 .t_line_node.active:after {
	border-color: {$colors['text_link']} !important;
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 #t_line_left,
#tl1.timeline.my_style_style_1 #t_line_right {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 #t_line_left:hover,
#tl1.timeline.my_style_style_1 #t_line_right:hover {
	color: {$colors['text_hover']} !important;
}
.timeline.my_style_style_1 .t_node_desc span {
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 .t_node_desc span:after {
	border-top-color: {$colors['text_link']};
}

/* Items */
#tl2.my_style_style_2 .item .my_category,
.timeline.my_style_style_1 .my_post_date {
	color: {$colors['inverse_text']} !important;
}
#tl1.timeline.my_style_style_1 .my_timeline_content .read_more {
	background-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 .my_timeline_content .read_more:hover {
	background-color: {$colors['text_hover']} !important;
}
#tl1.timeline.my_style_style_1 .item_node_hover:before {
	background-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_1 .item_node_hover:after {
	border-top-color: {$colors['text_link']} !important;
}
#tl2 .item_open .t_close:hover,
#tl1 .item_open .t_close:hover,
#content #tl1 .item_open .t_close:hover {
	color: {$colors['text_link']} !important;
}

CSS;
		}
		
		return $css;
	}
}
?>