<?php
/**
 * The Portfolio template for displaying content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

$blog_style = explode('_', mckinney_politics_get_theme_option('blog_style'));
$columns = empty($blog_style[1]) ? 2 : max(2, $blog_style[1]);
$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$animation = mckinney_politics_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($columns).' post_format_'.esc_attr($post_format) ); ?>
	<?php echo (!mckinney_politics_is_off($animation) ? ' data-animation="'.esc_attr(mckinney_politics_get_animation_classes($animation)).'"' : ''); ?>
	>

	<?php
	$image_hover = mckinney_politics_get_theme_option('image_hover');
	// Featured image
	mckinney_politics_show_post_featured(array(
		'thumb_size' => mckinney_politics_get_thumb_size(strpos(mckinney_politics_get_theme_option('body_style'), 'full')!==false ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>