<?php
/**
 * The template to display "Header 1"
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

$header_css = $header_image = '';
$header_video = wp_is_mobile() ? '' : mckinney_politics_get_theme_option('header_video');
if (true || empty($header_video)) {
	$header_image = get_header_image();
	if (mckinney_politics_is_on(mckinney_politics_get_theme_option('header_image_override')) && apply_filters('mckinney_politics_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($cat_img = mckinney_politics_get_category_image()) != '')
				$header_image = $cat_img;
		} else if ((is_singular() || mckinney_politics_storage_isset('blog_archive')) && has_post_thumbnail()) {
			$header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
			if (is_array($header_image)) $header_image = $header_image[0];
		}
	}
}
$header_css = $header_image!='' ? ' style="background-image: url('.esc_url($header_image).')"' : '';

// Store header image for navi
set_query_var('mckinney_politics_header_image', $header_image || $header_video);

?><header class="top_panel top_panel_style_1<?php
					echo !empty($header_image) || !empty($header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($header_video!='') echo ' with_bg_video';
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (mckinney_politics_is_on(mckinney_politics_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(mckinney_politics_is_inherit(mckinney_politics_get_theme_option('header_scheme')) 
													? mckinney_politics_get_theme_option('color_scheme') 
													: mckinney_politics_get_theme_option('header_scheme')); ?>"
			<?php echo trim($header_css); ?>><?php
	// Mobile menu button
	?><a class="menu_mobile_button"></a><?php
	// Navigation panel
	get_template_part( 'templates/header-navi' );
	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');
	// Header widgets area
	get_template_part( 'templates/header-widgets' );
	// Header for single posts
	get_template_part( 'templates/header-single' );
?></header>