<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_mailchimp_theme_setup9', 9 );
	function mckinney_politics_mailchimp_theme_setup9() {
		if (mckinney_politics_exists_mailchimp()) {
			if (is_admin()) {
				add_filter( 'mckinney_politics_filter_importer_options',				'mckinney_politics_mailchimp_importer_set_options' );
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_importer_required_plugins',		'mckinney_politics_mailchimp_importer_required_plugins', 10, 2 );
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'mckinney_politics_exists_mailchimp' ) ) {
	function mckinney_politics_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_mailchimp_tgmpa_required_plugins' ) ) {
	//add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_mailchimp_tgmpa_required_plugins');
	function mckinney_politics_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', mckinney_politics_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'mckinney-politics'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}



// One-click import support
//------------------------------------------------------------------------

// Check Mail Chimp in the required plugins
if ( !function_exists( 'mckinney_politics_mailchimp_importer_required_plugins' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_required_plugins',	'mckinney_politics_mailchimp_importer_required_plugins', 10, 2 );
	function mckinney_politics_mailchimp_importer_required_plugins($not_installed='', $list='') {
		//if (in_array('mailchimp', mckinney_politics_storage_get('required_plugins')) && !mckinney_politics_exists_mailchimp() )
		if (strpos($list, 'mailchimp-for-wp')!==false && !mckinney_politics_exists_mailchimp() )
			$not_installed .= '<br>' . esc_html__('MailChimp for WP', 'mckinney-politics');
		return $not_installed;
	}
}

// Set options for one-click importer
if ( !function_exists( 'mckinney_politics_mailchimp_importer_set_options' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_options',	'mckinney_politics_mailchimp_importer_set_options' );
	function mckinney_politics_mailchimp_importer_set_options($options=array()) {
		if (is_array($options)) {
			$options['additional_options'][] = 'mc4wp_default_form_id';		// Add slugs to export options for this plugin
			$options['additional_options'][] = 'mc4wp_form_stylesheets';
			$options['additional_options'][] = 'mc4wp_flash_messages';
			$options['additional_options'][] = 'mc4wp_integrations';
		}
		return $options;
	}
}
?>