<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

// Thumb image
$thumb_image = wp_get_attachment_image_src(get_post_thumbnail_id(), mckinney_politics_get_thumb_size('medium')) ;

if (is_array($thumb_image)) $thumb_image = $thumb_image[0];
$link = get_permalink();
$hover = mckinney_politics_get_theme_option('image_hover');
?>



<div class="related_item related_item_style_2">
	<?php if (!empty($thumb_image)) { ?>
		<div class="post_featured<?php if (has_post_thumbnail()) echo ' hover_'.esc_attr($hover); ?>" style="background-image: url(<?php echo esc_url($thumb_image); ?>)">
			<?php
			if (has_post_thumbnail()) {
				?><div class="mask"></div><?php
				mckinney_politics_hovers_add_icons($hover);
			}
			?>
		</div>
	<?php } ?>


			<div class="post_header entry-header">
			<?php
			if ( in_array(get_post_type(), array( 'post', 'attachment' ) ) ) {
				?><span class="post_date"><a href="<?php echo esc_url($link); ?>"><?php echo get_the_date(); ?></a></span><?php
			}
			?>
			<h6 class="post_title entry-title"><a href="<?php echo esc_url($link); ?>"><?php echo the_title(); ?></a></h6>
		</div>
</div>
