<?php
/**
 * The template to show post's counters: views, likes, comments
 *
 * Used for widget and shortcode Recent News and many other shortcodes
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */

$args = get_query_var('trx_addons_args_post_counters');
$counters = !empty($args['counters']) ? $args['counters'] : 'views,likes,comments';
?>
<div class="post_counters<?php echo !empty($args['class']) ? ' '.esc_attr($args['class']) : ''; ?>"><?php

	// Counters
	echo trx_addons_get_post_counters($counters);
	
	// Socials share
	if ( !empty($args['share']) ) {
		$output = trx_addons_get_share_links(array(
				'type' => 'drop',
				'caption' => esc_html__('Share', 'trx_addons'),
				'echo' => false
			));
		if ($output) {
			?><div class="post_counters_item post_share"><?php echo trim($output); ?></div><?php
		}
	}

	// Edit page link
	edit_post_link( esc_html__( 'Edit', 'trx_addons' ), '<span class="post_counters_item post_counters_edit trx_addons_icon-pencil">', '</span>' );

?></div><?php
