<?php
/**
 * The style "default" of the Team
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_services');

$query_args = array(
	'post_type' => TRX_ADDONS_CPT_SERVICES_PT,
	'post_status' => 'publish',
	'posts_per_page' => $args['count'],
	'ignore_sticky_posts' => true,
	'orderby' => 'title',
	'order' => 'asc'
);
$query_args = trx_addons_query_add_posts_and_cats($query_args, '', TRX_ADDONS_CPT_SERVICES_PT, $args['cat'], TRX_ADDONS_CPT_SERVICES_TAXONOMY);
$query = new WP_Query( $query_args );
if ($query->found_posts > 0) {
	if ($args['count'] > $query->found_posts) $args['count'] = $query->found_posts;
	if ($args['columns'] < 1) $args['columns'] = $args['count'];
	$args['columns'] = max(1, min(12, (int) $args['columns']));
	$args['slides_space'] = max(0, (int) $args['slides_space']);
	?><div class="sc_services sc_services_default"<?php
			echo ($args['columns'] > 1 ? ' data-slides-per-view="' . esc_attr($args['columns']) . '"' : '')
				. ($args['slides_space'] > 0 ? ' data-slides-space="' . esc_attr($args['slides_space']) . '"' : '')
				. ' data-slides-min-width="150"';
				?>
		>
		<?php
		trx_addons_sc_show_titles('sc_services', $args);
		
		if ($args['columns'] > 1) {
			?><div class="sc_services_columns sc_item_columns <?php echo esc_attr(trx_addons_get_columns_wrap_class()); ?>"><?php
		} else {
			?><div class="sc_services_content sc_item_content"><?php
		}	

		set_query_var('trx_addons_args_sc_services', $args);
		$count = 1;
		while ( $query->have_posts() ) { $query->the_post();
			include trx_addons_get_file_dir( 'cpt/services/tpl.default-item.php' );
			$count++;
		}

		wp_reset_postdata();
	
		?></div><?php
		
		trx_addons_sc_show_links('sc_services', $args);

	?></div><!-- /.sc_services --><?php
}
?>