<?php
/**
 * Plugin support: Revolution Slider
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	die( '-1' );
}

// Check if plugin is installed and activated
if ( !function_exists( 'trx_addons_exists_content_timeline' ) ) {
	function trx_addons_exists_content_timeline() {
		return class_exists( 'ContentTimelineAdmin' );
	}
}

// Return Content Timelines list, prepended inherit (if need)
if ( !function_exists( 'trx_addons_get_list_content_timelines' ) ) {
	function trx_addons_get_list_content_timelines($prepend_inherit=false) {
		static $list = false;
		if ($list === false) {
			$list = array();
			if (trx_addons_exists_content_timeline()) {
				global $wpdb;
				$rows = $wpdb->get_results( "SELECT id, name FROM " . esc_sql($wpdb->prefix . 'ctimelines') );
				if (is_array($rows) && count($rows) > 0) {
					foreach ($rows as $row) {
						$list[$row->id] = $row->name;
					}
				}
			}
		}
		return $prepend_inherit ? array_merge(array('inherit' => esc_html__("Inherit", 'trx_addons')), $list) : $list;
	}
}


// Add [content_timeline] in the VC shortcodes list
if (!function_exists('trx_addons_sc_content_timeline_add_in_vc')) {
	function trx_addons_sc_content_timeline_add_in_vc() {

		if (!trx_addons_exists_visual_composer() || !trx_addons_exists_content_timeline()) return;

		$timelines_list = trx_addons_get_list_content_timelines();

		vc_map( apply_filters('trx_addons_sc_map', array(
				"base" => "content_timeline",
				"name" => esc_html__("Content Timeline", 'trx_addons'),
				"description" => esc_html__("Insert Content timeline", 'trx_addons'),
				"category" => esc_html__('Content', 'trx_addons'),
				'icon' => 'icon_trx_sc_content_timeline',
				"class" => "trx_sc_content_timeline",
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "id",
						"heading" => esc_html__("Timeline", 'trx_addons'),
						"description" => esc_html__("Select Timeline to insert into current page", 'trx_addons'),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip($timelines_list),
						"type" => "dropdown"
					)
				)
			), 'content_timeline' ) );
			
		class WPBakeryShortCode_Content_Timeline extends WPBakeryShortCode {}

	}
	add_action('after_setup_theme', 'trx_addons_sc_content_timeline_add_in_vc', 11);
}
?>