<?php

// === "db_breadcrumbs_filter_et_pb_layout" filter for content of global modules ===

add_filter('the_posts', 'db_breadcrumbs_filter_global_modules');

function db_breadcrumbs_filter_global_modules($posts) {
	
	// Apply filters to builder layouts
	if (!is_admin() && !empty($posts) && count($posts)==1) { // If have one single result
		
		$is_et_pb_layout = (isset($posts[0]->post_type) && $posts[0]->post_type == 'et_pb_layout');
		
		if ($is_et_pb_layout) { 
			$content = isset($posts[0]->post_content)?$posts[0]->post_content:''; 
			$posts[0]->post_content = apply_filters('db_breadcrumbs_filter_et_pb_layout', $content);
		}
	}
	
	return $posts;
}