<?php

add_action('wp_enqueue_scripts', 'db_breadcrumbs_enqueue_css');
add_action('dbbc_before_main_content', 'db_breadcrumbs_add_breadcrumbs_to_header');
add_filter('et_epanel_layout_data', 'db_breadcrumbs_add_global_breadcrumbs_option');

// Fix layout id gets cast to string when saved as option, which prevents "selected" from working on the theme option select menu
add_filter('et_get_option_et_divi_divi_db_breadcrumbs_layout', 'db_breadcrumbs_cast_selected_layout_id_back_to_int');

function db_breadcrumbs_enqueue_css() {
	wp_enqueue_style('et_pb_dmb_breadcrumbs-css', plugins_url('style.css', DBDBM_FILE));
}

function db_breadcrumbs_add_breadcrumbs_to_header() {

	$layout_id = et_get_option('divi_db_breadcrumbs_layout');
	if (empty($layout_id)) { return; }
	
	$show_on_homepage = et_get_option('divi_db_breadcrumbs_show_on_home');

	if (!is_front_page() || (!empty($show_on_homepage) && $show_on_homepage === 'on')) {
		
		// Get the section content
		remove_filter('db_breadcrumbs_filter_et_pb_layout', 'DMB_remove_unwanted_breadcrumbs');
		$breadcrumbs = do_shortcode('[et_pb_section global_module="'.esc_attr($layout_id).'"][/et_pb_section]');
		add_filter('db_breadcrumbs_filter_et_pb_layout', 'DMB_remove_unwanted_breadcrumbs');
		
		echo '<div id="db_breadcrumbs_header">'.$breadcrumbs.'</div>';
	}
}

function db_breadcrumbs_add_global_breadcrumbs_option($options) {
	
	// Get the layouts
	$query = new WP_Query(array(
		'posts_per_page' => -1,
		'post_type'  => 'et_pb_layout',
		'meta_query' => array(
			'key'     => '_et_pb_predefined_layout',
			'value'   => 'on',
			'compare' => 'NOT EXISTS',
		),
	));
	wp_reset_postdata();
	if (empty($query->posts)) { return $options; }

	// Get the sections which contain breadcrumbs modules
	$breadcrumbs_sections = array('' => 'None');
	foreach($query->posts as $layout) {
		if (isset($layout->ID) && !empty($layout->post_content)) {
			$is_section = (substr_count($layout->post_content, 'et_pb_section') == 2);
			$has_breadcrumbs = (strpos($layout->post_content, '[et_pb_dmb_breadcrumbs ') !== false);
			if ($is_section && $has_breadcrumbs) {
				$breadcrumbs_sections[$layout->ID] = esc_html($layout->post_title);
			}
		}
	}
	
	// Add breadcrumbs options to the Divi settings
	$newoptions = array();
	
	foreach($options as $k=>$v) {
		
		// Insert options at the right place in the array - just before the end of the Navigation > General Settings tab
		if (!empty($v['name']) && $v['name'] === 'navigation-3' && 
			!empty($v['type']) && $v['type'] === 'subcontent-end') {
			$newoptions[] = array(
				"name" => "Add breadcrumbs section from library below header",
				"id" => 'divi_db_breadcrumbs_layout',
				"type" => "select",
				"options" => $breadcrumbs_sections,
				"std" => '',
				"desc" => "Choose a layout to use as a site-wide breadcrumbs bar. Added by the Divi Breadcrumbs Module from Divi Booster.",
				'et_save_values' => true,
			);
			$newoptions[] = array(
				"name" => "Show breadcrumbs section on homepage",
				"id" => 'divi_db_breadcrumbs_show_on_home',
				"type" => "checkbox",
				"std" => "false",
				"desc" => "Choose whether to show the breadcrumbs section on the homepage. Added by the Divi Breadcrumbs Module from Divi Booster."
			);
		}
		$newoptions[] = $v;
	}
	
	return $newoptions;
}


function db_breadcrumbs_cast_selected_layout_id_back_to_int($selected_layout_id) {
	if (!empty($selected_layout_id)) {
		return intval($selected_layout_id);
	}
	return $selected_layout_id;
}